//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 3 lights, 46 textures and 180 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 04/30/1997    (30.04.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.500,0.500,0.500> }

camera {  //  Camera StdCam
  location  <18.332, -20.166, 13.236>
  direction <0.0,     0.0,  2.2808>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <25.430, 5.076, 6.091>
}

// *******  L I G H T S *******
light_source {   // TheSun
  <-135.166, 23.035, 26.550>
  color rgb <0.847, 0.541, 0.541>
}

light_source { // AreaL001
  <22.934, 1.134, 9.633>
  color  rgb<0.361, 0.361, 0.040>
  area_light <2.527, -1.963, 0.000>, <0.245, 0.316, 0.000>, 5, 5
  adaptive 1
  jitter
}


light_source {   // Camera_Light
  <28.307, -26.626, 15.002>
  color rgb <0.214, 0.214, 0.214>
  shadowless
}


// ********  TEXTURES  *******
//

#include "desk.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

difference { // portHoles
  cylinder { // PortHole1
    <0,0,1>, <0,0,0>, 1 
    scale <4.15, 4.15, 1.0>
    rotate <90.0, -90.0, 0.0>
    translate  <20.340488, 4.535353, 9.985016>
  }
  cylinder { // PortHole2
    <0,0,1>, <0,0,0>, 1 
    scale <3.85, 3.85, 3.0>
    rotate <90.0, -90.0, 0.0>
    translate  <20.340488, 4.827033, 9.985016>
  }
  texture {
    DeskTexture
  }
  translate  <0.0, 2.254243, 0.047963>
}


box { // Wall1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WallPaper
  }
  scale <50.0, 1.0, 50.0>
  rotate -90.0*z
  translate  <-15.35, -42.000001, 0.0>
}


#declare BookPages5 = union {
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <1.300191, -0.075122, 0.0>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <-1.300191, -0.075122, 0.0>
  }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <1.4, 0.05, 0.28>
    translate  <-0.011557, -0.999703, 0.0>
  }
}
#declare Book1cut4 = difference {
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RedBook
    }
    scale <1.3, 1.0, 0.3>
  }
  object { BookPages5 }
}
#declare Spinedone5 = intersection {
  cylinder { // Spine4
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.300191, 1.00028, 0.001734>
  }
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.1, 0.3>
    translate  1.099948*y
  }
  texture {
    BrownSpine
  }
}
union { // BookDone5
  object { Book1cut4 }
  object { Spinedone5 }
  rotate -132.790359*z
  translate  <21.110091, 1.88975, 6.3>
}


union { // PlanetSystem
  sphere { // Moon1
    <0,0,0>,1
    texture {
      MoonSkin
    }
    scale 0.7
    translate  <45.567617, 115.54202, 14.499646>
  }
  sphere { // Planet
    <0,0,0>,1
    texture {
      PlanetSkin
    }
    scale 3.2
    rotate -30.0*z
    translate  <40.600001, 96.900001, 16.85>
  }
  sphere { // Moon2
    <0,0,0>,1
    texture {
      MoonSkin
    }
    translate  <47.763235, 95.384594, 19.0>
  }
  no_shadow
  translate  <-19.666047, -49.890562, -11.542497>
}


#declare SideTwoDone1 = union {
  cylinder { // edge9
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.272496, -0.392751, 8.11>
  }
  cylinder { // edge10
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <5.363407, -0.301573, 8.11>
  }
  cylinder { // edge11
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <2.16378, -0.292543, 8.114522>
  }
  cylinder { // edge12
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.26325, 2.806297, 8.11>
  }
  box { // NewsCube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Side_Two
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <1.6, 1.6, 0.1>
    translate  <3.766235, 1.214063, 8.109707>
  }
  rotate <-90.0, 0.0, 90.0>
  translate  <10.272904, -2.547802, 7.714063>
}
#declare SideTwoDone = union {
  cylinder { // edge5
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.272496, -0.392751, 8.11>
  }
  cylinder { // edge6
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <5.363407, -0.301573, 8.11>
  }
  cylinder { // edge7
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <2.16378, -0.292543, 8.114522>
  }
  cylinder { // edge8
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.26325, 2.806297, 8.11>
  }
  box { // NewsCube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Side_Three
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <1.6, 1.6, 0.1>
    translate  <3.766235, 1.214063, 8.109707>
  }
  rotate -90.0*x
  translate  <0.0, -5.306628, 7.714063>
}
#declare SideOneDone = union {
  cylinder { // edge4
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.272496, -0.392751, 8.11>
  }
  cylinder { // edge3
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate -90.0*x
    translate  <5.363407, -0.301573, 8.11>
  }
  cylinder { // edge2
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <2.16378, -0.292543, 8.114522>
  }
  cylinder { // edge1
    <0,0,1>, <0,0,0>, 1 
    texture {
      offWhite
    }
    scale <0.1, 0.1, 3.0>
    rotate 90.0*y
    translate  <2.26325, 2.806297, 8.11>
  }
  box { // NewsCube1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Side_One
      scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
    }
    scale <1.6, 1.6, 0.1>
    translate  <3.766235, 1.214063, 8.109707>
  }
}
union { // NewsCube
  object { SideTwoDone1 }
  object { SideTwoDone }
  object { SideOneDone }
  rotate <0.0, -9.0, 112.0>
  translate  <31.105688, -0.970659, 2.37>
}


#declare BookPages4 = union {
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <1.300191, -0.075122, 0.0>
  }
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <-1.300191, -0.075122, 0.0>
  }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <1.4, 0.05, 0.28>
    translate  <-0.011557, -0.999703, 0.0>
  }
}
#declare Book1cut3 = difference {
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PurpleBook
    }
    scale <1.3, 1.0, 0.3>
  }
  object { BookPages4 }
}
#declare Spinedone4 = intersection {
  cylinder { // Spine3
    <0,0,1>, <0,0,0>, 1 
    scale <0.17, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.300191, 1.00028, 0.001734>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.1, 0.3>
    translate  1.099948*y
  }
  texture {
    BlackSpine
  }
}
union { // BookDone4
  object { Book1cut3 }
  object { Spinedone4 }
  rotate -13.0*z
  translate  <20.790964, 1.446039, 6.9>
}


box { // Page
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Letter
    scale <1.996042, 1.99591, 1.0>
  translate <-0.998749, -1.002224, 0.000000>
  }
  scale <1.0, 1.5, 0.005>
  rotate <0.0, 0.0, 21.617725>
  translate  <27.368329, -4.321518, 6.010572>
}


plane { // Stars
  z,0
  texture {
    StarField
  }
  scale 3.0
  rotate -90.0*x
  translate  <37.57059, 148.009597, 0.0>
}




#declare Bulb1 = union {
  cylinder { // LIght1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightbulb
    }
    scale <0.1, 0.2, 3.0>
    rotate <-90.0, 53.0, -90.0>
    translate  <20.796688, 1.549657, 9.622252>
  }
  sphere { // lightend3
    <0,0,0>,1
    texture {
      Lightbulb
    }
    scale <0.1, 0.1, 0.2>
    rotate <53.0, 0.0, 0.0>
    translate  <23.79568, 1.548713, 9.622601>
  }
  sphere { // lightend4
    <0,0,0>,1
    texture {
      Lightbulb
    }
    scale <0.1, 0.1, 0.2>
    rotate <53.0, 0.0, 0.0>
    translate  <20.79858, 1.548713, 9.622601>
  }
  translate  <1.0, 0.7, 6.05>
}
#declare shade_sides1 = difference {
  cylinder { // Shade_out1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.55, 4.0>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
  cylinder { // Shade_in1
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.5, 3.95>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
}
#declare ShadeDone1 = difference {
  object { shade_sides1 }
  box { // ShadeMinus1
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.7, 0.7>
    translate  <-4.07769, -0.934191, 9.352298>
  }
  texture {
    DeskTexture
  }
  translate  <27.4, 3.2, 5.55>
}
union { // overhead_light
  object { Bulb1 }
  object { ShadeDone1 }
  translate  <-4.033629, 2.830226, 0.0>
}




difference { // WallDone
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WallPaper
    }
    scale <50.0, 1.0, 50.0>
    translate  <35.0, 7.0, 0.0>
  }
  cylinder { // PortHole
    <0,0,1>, <0,0,0>, 1 
    texture {
      WallPaper
    }
    scale 4.0
    rotate <90.0, -90.0, 0.0>
    translate  <20.340488, 8.96123, 10.0>
  }
}


#declare DrawerDone4 = union {
  cylinder { // LockH4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.13>
    rotate 90.0*y
    translate  <-2.423462, -6.089071, 3.920284>
  }
  cylinder { // LockV4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.2>
    translate  <-2.402965, -6.0878, 3.900165>
  }
  torus { // Open3
    1.0, 0.1  rotate -x*90
    texture {
      Blue_Glass1
    }
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <-2.814936, -6.090408, 4.002067>
  }
  box { // DrawerBtnO4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.805903, -5.890961, 4.00267>
  }
  box { // DrawerBtnL4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.357841, -5.889889, 4.00267>
  }
  box { // drawer4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTexture
    }
    scale <3.4, 5.9, 0.9>
    translate  <-5.430045, -0.176776, 3.435751>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -6.75>
}
#declare DrawerDone3 = union {
  cylinder { // LockH3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.13>
    rotate 90.0*y
    translate  <-2.423462, -6.089071, 3.920284>
  }
  cylinder { // LockV3
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.2>
    translate  <-2.402965, -6.0878, 3.900165>
  }
  torus { // Open2
    1.0, 0.1  rotate -x*90
    texture {
      Blue_Glass1
    }
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <-2.814936, -6.090408, 4.002067>
  }
  box { // DrawerBtnO3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.805903, -5.890961, 4.00267>
  }
  box { // DrawerBtnL3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.357841, -5.889889, 4.00267>
  }
  box { // drawer3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTexture
    }
    scale <3.4, 5.9, 0.9>
    translate  <-5.430045, -0.176776, 3.435751>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -4.5>
}
#declare DrawerDone2 = union {
  cylinder { // LockH2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.13>
    rotate 90.0*y
    translate  <-2.423462, -6.089071, 3.920284>
  }
  cylinder { // LockV2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.2>
    translate  <-2.402965, -6.0878, 3.900165>
  }
  torus { // Open1
    1.0, 0.1  rotate -x*90
    texture {
      Blue_Glass1
    }
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <-2.814936, -6.090408, 4.002067>
  }
  box { // DrawerBtnO2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.805903, -5.890961, 4.00267>
  }
  box { // DrawerBtnL2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.357841, -5.889889, 4.00267>
  }
  box { // drawer2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTexture
    }
    scale <3.4, 5.9, 0.9>
    translate  <-5.430045, -0.176776, 3.435751>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.25>
}
#declare DrawerDone1 = union {
  cylinder { // LockH1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.13>
    rotate 90.0*y
    translate  <-2.423462, -6.089071, 3.920284>
  }
  cylinder { // LockV1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale <0.02, 0.02, 0.2>
    translate  <-2.402965, -6.0878, 3.900165>
  }
  torus { // Open
    1.0, 0.1  rotate -x*90
    texture {
      Blue_Glass1
    }
    scale <0.1, 0.1, 0.2>
    rotate -90.0*x
    translate  <-2.814936, -6.090408, 4.002067>
  }
  box { // DrawerBtnO1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.805903, -5.890961, 4.00267>
  }
  box { // DrawerBtnL1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SilverDesk
    }
    scale 0.2
    translate  <-2.357841, -5.889889, 4.00267>
  }
  box { // drawer1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTexture
    }
    scale <3.4, 5.9, 0.9>
    translate  <-5.430045, -0.176776, 3.435751>
  }
  rotate <0.0, 0.0, 0.0>
  translate  <0.0, 0.0, 0.0>
}
#declare NoSignDone = difference {
  cylinder { // NoSignout
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*x
  }
  cylinder { // NoSignIn
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 2.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  texture {
    RedSign
  }
  scale <0.5, 0.05, 0.5>
  translate  <-2.572423, -6.25, 0.968444>
}
#declare YesSignDone = difference {
  cylinder { // YesSignout
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*x
  }
  cylinder { // YesSignIn
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 2.0>
    rotate -90.0*x
    translate  -0.5*y
  }
  texture {
    GreenSign
  }
  scale <0.5, 0.05, 0.5>
  translate  <-2.574525, -6.25, 3.189809>
}
#declare drawer_cuts = union {
  box { // drawer_cutout1
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 6.0, 1.0>
    translate  <-5.430045, -0.244238, 3.435751>
  }
  box { // drawer_cutout3
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 6.0, 1.0>
    translate  <-5.430045, -0.244238, 1.235751>
  }
  box { // drawer_cutout4
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 6.0, 1.0>
    translate  <-5.430045, -0.244238, -0.964249>
  }
  box { // drawer_cutout2
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 6.0, 1.0>
    translate  <-5.430045, -0.244238, -3.164249>
  }
  box { // desk_cut_out
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 6.2, 5.5>
    translate  <3.646746, -0.122119, -1.041927>
  }
  cylinder { // CompScreenHole
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 0.7>
    translate  <3.859071, 0.996289, 5.497218>
  }
  texture {
    BlackDesk
  }
}
#declare deskbody = difference {
  box { // Desk
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DeskTexture
    }
    scale <9.5, 6.0, 6.0>
  }
  object { drawer_cuts }
}
#declare Small_Sun = union {
  sphere { // sphere50_1316
    <0,0,0>,1
    scale <2.5, 1.0, 2.5>
  }
  cone { // cone23_1317
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
    translate  -6.0*z
  }
  cone { // cone24_1318
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
    rotate 270.0*y
    translate  6.0*x
  }
  cone { // cone25_1319
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
    rotate <180.0, 360.0, 180.0>
    translate  6.0*z
  }
  cone { // cone26_1320
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 5.0>
    rotate <180.0, 90.0, 180.0>
    translate  -6.0*x
  }
  cone { // cone27_1321
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.5>
    rotate <180.0, 315.0, 180.0>
    translate  <3.6, 0.0, 3.5>
  }
  cone { // cone28_1322
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.5>
    rotate <180.0, 45.0, 180.0>
    translate  <-3.6, 0.0, 3.5>
  }
  cone { // cone29_1323
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.5>
    rotate 45.0*y
    translate  <-3.6, 0.0, -3.5>
  }
  cone { // cone30_1324
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 3.5>
    rotate 315.0*y
    translate  <3.5, 0.0, -3.6>
  }
  texture {
    Small_Gold_Sun
  }
  scale <0.16, 0.08, 0.16>
  rotate <-90.0, 0.0, -22.5>
  translate  <101.980798, -3.308755, 7.543705>
}
#declare Symbol = union {
  cylinder { // Symbol3
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.02, 0.4>
    rotate -90.0*y
    translate  <100.368537, -3.380237, 8.78553>
  }
  cylinder { // Symbol4
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.02, 0.4>
    rotate <-68.0, -90.0, 0.0>
    translate  <100.137889, -3.743023, 8.78553>
  }
  cylinder { // Symbol5
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.02, 0.4>
    rotate <68.0, -90.0, 0.0>
    translate  <100.347976, -3.371798, 8.78553>
  }
  cylinder { // Symbol1
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.02, 0.4>
    rotate -90.0*y
    translate  <100.145623, -3.731544, 8.78553>
  }
  cylinder { // Symbol2
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.02, 0.4>
    rotate -90.0*y
    translate  <100.590152, -3.732501, 8.78553>
  }
  texture {
    Shiny_Black
  }
  scale <0.8, 0.8, 0.1>
  translate  <21.845373, -0.462855, 6.735011>
}
#declare SymbolEngrave = difference {
  object { Small_Sun }
  object { Symbol }
}
#declare Crest = object { 
  height_field {
    gif "C:\JUNK\POVMORAY\BORDER1.GIF"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    DiplomaTexture
  }
  scale <2.682013, 0.238001, 0.27373>
  rotate 0.0*y
  translate  <1.137591, -1.566827, -0.124343>
}
#declare Crest1 = object { 
  height_field {
    gif "C:\JUNK\POVMORAY\BORDER1.GIF"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    DiplomaTexture
  }
  scale <1.72813, 0.238001, 0.27373>
  rotate <0.0, 0.0, -90.0>
  translate  <-1.869969, 0.420011, -0.122504>
}
#declare engrave = union {
  object { Crest }
  object { Crest1 }
  rotate 0.0*y
}
#declare Cut_btm = difference {
  object { engrave }
  box { // Btmcut
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DiplomaTexture
    }
    scale <3.5, 2.4, 1.0>
    translate  <0.861889, 0.091938, -0.895284>
  }
  rotate 0.0*y
  translate  <99.150001, -4.5, 7.319988>
}
#declare Cresteboss = object { 
  height_field {
    gif "C:\JUNK\POVMORAY\CREST.GIF"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    DiplomaTexture
  }
  scale <1.7, 1.7, 0.05>
  translate  <99.303566, -4.09846, 7.455411>
}
#declare Diploma_Words = object { 
  height_field {
    tga "C:\JUNK\POVMORAY\DIPLWORD.TGA"
    water_level 0.05
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    FlatBlack
  }
  scale <2.0, 1.0, 0.05>
  translate  <-0.324231, -4.112484, 6.239266>
}
#declare WordDone1 = difference {
  object { Diploma_Words }
  box { // wordback
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 1.1, 0.31>
    translate  <-0.357717, -4.138601, 5.929051>
  }
  texture {
    FlatBlack
  }
  rotate 0.0*x
  translate  <100.596699, -0.676906, 1.40551>
}
#declare Diploma_School = object { 
  height_field {
    tga "C:\JUNK\POVMORAY\DIPLSCHL.TGA"
    water_level 0.0949
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    FlatBlack
  }
  scale <1.9, 0.422222, 0.025>
  rotate <0.0, 0.0, 0.0>
  translate  <99.445272, -3.173863, 7.599148>
}
#declare DiplomaDone = union {
  box { // Diploma_Sheet
    <-1, -1, -1>, <1, 1, 1>
    texture {
      DiplomaTexture
    }
    scale <3.0, 2.0, 0.01>
    rotate 0.0*y
    translate  <100.0, -4.318013, 7.42144>
  }
  object { SymbolEngrave }
  torus { // Ring
    1.9, 0.1  rotate -x*90
    texture {
      DiplomaTexture
    }
    scale 0.1
    rotate 0.0*y
    translate  <97.314619, -6.054814, 7.493523>
  }
  sphere { // Corner1
    <0,0,0>,1
    texture {
      Chrome_Metal
    }
    scale 0.05
    rotate 0.0*y
    translate  <97.447333, -5.931856, 7.493523>
  }
  sphere { // Corner
    <0,0,0>,1
    texture {
      Gold_Texture
    }
    scale 0.05
    rotate 0.0*y
    translate  <97.348612, -6.127925, 7.493523>
  }
  object { Cut_btm }
  object { Cresteboss }
  object { WordDone1 }
  object { Diploma_School }
  rotate <55.0, 0.0, -13.0>
  translate  <-97.715297, 30.796281, 6.942364>
}
#declare Armature = union {
  cylinder { // Base4
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.46>
    rotate <-110.0, 0.0, 0.0>
    translate  <-3.95, -1.471453, 10.305386>
  }
  cylinder { // Joint3
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, -1.5, 10.3>
  }
  cylinder { // Base3
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.46>
    rotate <-22.0, 0.0, 0.0>
    translate  <-3.95, -1.682615, 9.895654>
  }
  cylinder { // Joint2
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, -1.05, 10.15>
  }
  cylinder { // Joint1
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 0.3>
    rotate -90.0*y
    translate  <-3.8, 0.0, 9.05>
  }
  cylinder { // Base2
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.5>
    rotate <43.49482, 0.0, 0.0>
    translate  <-3.95, 0.0, 9.05>
  }
  cone { // Base
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 0.25>
    rotate <180.0, 0.0, -142.0>
    translate  <-3.951408, 0.025391, 6.221959>
  }
  cylinder { // Base1
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.95>
    rotate <0.0, 0.0, 38.0>
    translate  <-3.950274, 0.025589, 6.088298>
  }
  texture {
    Gold_Metal
  }
  translate  <0.128832, 0.640917, 1.552341>
}
#declare shade_sides = difference {
  cylinder { // Shade_out
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 0.55, 4.0>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
  cylinder { // Shade_in
    <0,0,1>, <0,0,0>, 1 
    scale <0.35, 0.5, 3.95>
    rotate -90.0*y
    translate  <-2.1, -0.95, 10.1>
  }
}
#declare ShadeDone = difference {
  object { shade_sides }
  box { // ShadeMinus
    <-1, -1, -1>, <1, 1, 1>
    scale <2.1, 0.7, 0.7>
    translate  <-4.108971, -0.930353, 9.352432>
  }
  texture {
    ShinyGreen
  }
  rotate <-2.0, 0.0, 0.0>
  translate  <0.25, -0.705795, 1.018869>
}
#declare Bulb = union {
  cylinder { // LIght
    <0,0,1>, <0,0,0>, 1 
    texture {
      Lightbulb
    }
    scale <0.1, 0.2, 3.0>
    rotate <-90.0, 53.0, -90.0>
    translate  <20.796688, 1.549657, 9.622252>
  }
  sphere { // lightend1
    <0,0,0>,1
    texture {
      Lightbulb
    }
    scale <0.1, 0.1, 0.2>
    rotate <53.0, 0.0, 0.0>
    translate  <23.79568, 1.548713, 9.622601>
  }
  sphere { // lightend2
    <0,0,0>,1
    texture {
      Lightbulb
    }
    scale <0.1, 0.1, 0.2>
    rotate <53.0, 0.0, 0.0>
    translate  <20.79858, 1.548713, 9.622601>
  }
  rotate <33.548237, 0.0, 0.0>
  translate  <-26.193842, 2.733765, 2.275312>
}
#declare LampDone = union {
  object { Armature }
  object { ShadeDone }
  object { Bulb }
  no_shadow
  hollow
  rotate -38.0*z
  translate  <1.809162, -0.231227, -1.518259>
}
#declare PadWindow = difference {
  box { // PADD
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PrevDeskTexture
    }
    scale <1.45, 1.1, 0.075>
    translate  <-3.9, -0.9, 8.162785>
  }
  box { // PADDScrn
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Shiny_Black3
    }
    scale <1.05, 1.05, 0.02>
    translate  <-4.222526, -0.886648, 8.24095>
  }
}
#declare PADDone = union {
  object { PadWindow }
  box { // PADDBtn1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Red_Glass
    }
    scale <0.05, 0.1, 0.01>
    translate  <-3.028916, 0.053141, 8.268038>
  }
  box { // PADDBtn2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Blue_Glass
    }
    scale <0.13, 0.1, 0.01>
    translate  <-2.729872, 0.049437, 8.268038>
  }
  box { // PADDBtn3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-3.0, -0.3, 8.25>
  }
  box { // PADDBtn4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-2.8, -0.55, 8.25>
  }
  box { // PADDBtn5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-3.0, -0.8, 8.25>
  }
  box { // PADDBtn6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-2.8, -1.05, 8.25>
  }
  box { // PADDBtn7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-3.0, -1.3, 8.25>
  }
  box { // PADDBtn8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-2.8, -1.55, 8.25>
  }
  box { // PADDBtn9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.08, 0.1, 0.01>
    translate  <-3.0, -1.8, 8.25>
  }
  box { // PADDBtn10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhite
    }
    scale <0.07, 0.7, 0.01>
    translate  <-2.570068, -1.051403, 8.25>
  }
  rotate 19.842896*z
  translate  <-3.538361, 1.836409, -0.88>
}
#declare BookPages1 = union {
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <1.300191, -0.075122, 0.0>
  }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <-1.300191, -0.075122, 0.0>
  }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <1.4, 0.05, 0.28>
    translate  <-0.011557, -0.999703, 0.0>
  }
}
#declare Book1cut = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    texture {
      PurpleBook
    }
    scale <1.3, 1.0, 0.3>
  }
  object { BookPages1 }
}
#declare Spinedone1 = intersection {
  cylinder { // Spine
    <0,0,1>, <0,0,0>, 1 
    texture {
      BlackSpineWwords
    }
    scale <0.17, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.300191, 1.00028, 0.001734>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlackSpineWwords
    }
    scale <1.3, 0.1, 0.3>
    translate  1.099948*y
  }
}
#declare BookDone1 = union {
  object { Book1cut }
  object { Spinedone1 }
  rotate 168.0*z
  translate  <-6.85, 0.0, 6.31>
}
#declare BookPages2 = union {
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <1.300191, -0.075122, 0.0>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <-1.300191, -0.075122, 0.0>
  }
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <1.4, 0.05, 0.28>
    translate  <-0.011557, -0.999703, 0.0>
  }
}
#declare Book1cut1 = difference {
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RedBook
    }
    scale <1.3, 1.0, 0.3>
  }
  object { BookPages2 }
}
#declare Spinedone2 = intersection {
  cylinder { // Spine1
    <0,0,1>, <0,0,0>, 1 
    scale <0.19, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.300191, 1.00028, 0.001734>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.1, 0.3>
    translate  1.099948*y
  }
  texture {
    BrownSpine
  }
}
#declare BookDone2 = union {
  object { Book1cut1 }
  object { Spinedone2 }
  rotate -175.0*z
  translate  <-7.011044, 0.354296, 6.893584>
}
#declare BookPages3 = union {
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <1.300191, -0.075122, 0.0>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <0.05, 1.0, 0.28>
    translate  <-1.300191, -0.075122, 0.0>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      offWhitePages
    }
    scale <1.4, 0.05, 0.28>
    translate  <-0.011557, -0.999703, 0.0>
  }
}
#declare Book1cut2 = difference {
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlueBook
    }
    scale <1.3, 1.0, 0.3>
  }
  object { BookPages3 }
}
#declare Spinedone3 = intersection {
  cylinder { // Spine2
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.3, 2.6>
    rotate <-90.0, 0.0, -90.0>
    translate  <-1.300191, 1.00028, 0.001734>
  }
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <1.3, 0.1, 0.3>
    translate  1.099948*y
  }
  texture {
    BlackSpine
  }
}
#declare BookDone3 = union {
  object { Book1cut2 }
  object { Spinedone3 }
  rotate <137.295914, -3.678624, 3.388733>
  translate  <-6.773108, 2.010853, 6.95218>
}
#declare Books = union {
  object { PADDone }
  object { BookDone1 }
  object { BookDone2 }
  object { BookDone3 }
  rotate 34.0*z
  translate  <-1.344247, 1.716888, 0.0>
}
#declare Bits = union {
  cylinder { // Buttons5
    <0,0,1>, <0,0,0>, 1 
    texture {
      Blue_Glass1
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.543277, -0.001786, 6.197856>
  }
  cylinder { // Buttons4
    <0,0,1>, <0,0,0>, 1 
    texture {
      Red_Glass1
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.543277, 0.203307, 6.152992>
  }
  cylinder { // Buttons3
    <0,0,1>, <0,0,0>, 1 
    texture {
      PurpleBook
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.543277, 0.200102, 6.239516>
  }
  cylinder { // Buttons2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Small_Gold_Sun
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.543277, 0.260989, 6.191447>
  }
  cylinder { // Buttons1
    <0,0,1>, <0,0,0>, 1 
    texture {
      ShinyGreen
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.545697, 0.415821, 6.191447>
  }
  cylinder { // Buttons
    <0,0,1>, <0,0,0>, 1 
    texture {
      TransWhite
    }
    scale 0.02
    rotate -90.0*y
    translate  <-0.543277, 0.485979, 6.191447>
  }
}
#declare Grips = union {
  torus { // FingerGrip1
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  -0.004686*y
  }
  torus { // FingerGrip2
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  0.2*z
  }
  torus { // FingerGrip3
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  0.4*z
  }
  torus { // FingerGrip4
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  <0.0, -0.004686, 1.75>
  }
  torus { // FingerGrip5
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  1.95*z
  }
  torus { // FingerGrip6
    1.5, 0.5  rotate -x*90
    scale <0.17, 0.17, 0.2>
    translate  2.15*z
  }
  texture {
    BlackDesk
  }
  translate  3.0*z
}
#declare Hammer_cuts = difference {
  cylinder { // Handle
    <0,0,1>, <0,0,0>, 1 
    texture {
      Blue_Glass1
    }
    scale <0.2, 0.2, 3.0>
    translate  <0.0, -0.017571, 2.74483>
  }
  object { Grips }
}
#declare HammerHead = union {
  box { // Head
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BlueBook
    }
    scale <0.55, 0.7, 0.3>
    translate  6.0*z
  }
  cylinder { // piston
    <0,0,1>, <0,0,0>, 1 
    texture {
      TransWhite
    }
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <-0.232382, 0.172901, 6.009302>
  }
  cylinder { // piston1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Shiny_Black2
    }
    scale <0.2, 0.35, 0.3>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.0, 0.972265, 6.009302>
  }
  cylinder { // piston2
    <0,0,1>, <0,0,0>, 1 
    texture {
      TransWhite
    }
    scale <0.05, 0.05, 1.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.232382, 0.143853, 6.009302>
  }
}
#declare Pieces = union {
  box { // Door1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.14, 0.1>
    translate  <-0.463898, -0.294418, 5.816462>
  }
  box { // Door2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 0.28, 0.05>
    translate  <-0.463898, -0.395852, 6.209518>
  }
  box { // Door3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.21, 0.1, 0.1>
    translate  <-0.022272, -0.513619, 6.209518>
  }
  box { // Door4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.03, 0.4, 0.1>
    translate  <0.419355, 0.1341, 6.209518>
  }
  texture {
    DeskTexture
  }
}
#declare HammerDone = union {
  object { Bits }
  object { Hammer_cuts }
  object { HammerHead }
  object { Pieces }
  rotate <40.357239, 83.0, -160.0>
  translate  <7.45, -6.55, 106.0>
}
#declare Holos = union {
  cone { // Holo6
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Red_Glass1
    }
    scale <0.2, 0.2, 1.1>
    rotate <135.0, -45.0, -90.0>
    translate  <27.269152, 0.006329, 6.270749>
  }
  cone { // Holo3
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Greeen_Glass
    }
    scale <0.2, 0.2, 1.1>
    rotate <141.927628, -33.200821, -14.711637>
    translate  <29.319792, -0.882916, 6.416451>
  }
  cone { // Holo5
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blue_Glass1
    }
    scale <0.2, 0.2, 1.1>
    rotate <-170.0, -60.0, -55.0>
    translate  <30.512875, 0.043855, 6.270749>
  }
  cone { // Holo2
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Greeen_Glass
    }
    scale <0.2, 0.2, 1.1>
    rotate <111.601227, -16.315712, 172.889359>
    translate  <28.768639, 2.825874, 6.117786>
  }
  cone { // Holo1
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Red_Glass1
    }
    scale <0.2, 0.2, 1.1>
    rotate <137.013351, 12.216631, 135.494522>
    translate  <30.448418, 2.287864, 6.475202>
  }
  cone { // Holo7
    <0,0,0>, 0.0, <0,0,1>, 1.0
    texture {
      Blue_Glass1
    }
    scale <0.2, 0.2, 1.1>
    rotate <-152.897919, -24.457588, 90.823357>
    translate  <26.997276, 2.279699, 6.576677>
  }
  rotate <0.0, 0.0, -45.0>
  translate  <-17.3, 20.65, -0.036491>
}
union { // Whole_Desk
  object { DrawerDone4 }
  object { DrawerDone3 }
  object { DrawerDone2 }
  box { // NoSignLine
    <-1, -1, -1>, <1, 1, 1>
    texture {
      RedSign
    }
    scale <0.05, 0.02, 0.45>
    rotate <0.0, -45.0, 0.0>
    translate  <-2.57509, -6.229723, 0.954187>
  }
  object { DrawerDone1 }
  object { NoSignDone }
  object { YesSignDone }
  box { // Keyboard
    <-1, -1, -1>, <1, 1, 1>
    texture {
      KeyBoard
    }
    scale <2.548847, 1.221264, 0.1>
    translate  <3.873384, -4.132822, 5.905055>
  }
  object { deskbody }
  object { DiplomaDone }
  object { LampDone }
  object { Books }
  object { HammerDone }
  object { Holos }
  translate  25.0*x
}


box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  texture {
    Carpet
  }
  scale <50.0, 50.0, 1.0>
  translate  <34.711663, -42.662379, -7.017942>
}




